#if 0

/*
	File:		FormatAsDOSDisk.c
	
	Description:This snippet demonstrates how to use the newer Disk Initialization
				Package calls DIXFormat() and DIXZero() to format a floppy disk as
				a DOS disk.  DIXFormat, DIXZero, and DIReformat are documented in 
				the IM:Files Errata Tech Note.
	
				Please note this snippet does not provide any prompts.  It merely takes
				the floppy in the first floppy drive and reformats it as a DOS disk with 
				the name "MS-DOS Disk".  This purpose of this snippet is to demonstrate
				the newer API.

	Author:		JL & VMC

	Copyright: 	Copyright:  1996-1999 by Apple Computer, Inc.
				all rights reserved.
	
	Disclaimer:	You may incorporate this sample code into your applications without
				restriction, though the sample code has been provided "AS IS" and the
				responsibility for its operation is 100% yours.  However, what you are
				not permitted to do is to redistribute the source as "DSC Sample Code"
				after having made changes. If you're going to re-distribute the source,
				we require that you make it clear in the source that the code was
				descended from Apple Sample Code, but that you've made changes.
	
	Change History (most recent first):
				6/24/99	Updated for Metrowerks Codewarror Pro 2.1(KG)

*/

#include <Gestalt.h>
#include <FSM.h>
#include <DiskInit.h>

/******************************************************************************/

/*
**	Prototypes and inlines for newer Disk INIT calls
*/

extern pascal OSErr DIXFormat(short drvNum, Boolean fmtFlag, unsigned long fmtArg, 
						  unsigned long *actSize)
		THREEWORDINLINE(0x700C, 0x3F00, 0xA9E9);

extern pascal OSErr DIXZero(short drvNum, ConstStr255Param volName, short fsid,
						short mediaStatus, short volTypeSelector,
						unsigned long volSize, void *extendedInfoPtr)
		THREEWORDINLINE(0x700E, 0x3F00, 0xA9E9);

extern pascal OSErr DIReformat(short drvNum, short fsid, ConstStr255Param volName,
						   ConstStr255Param msgText)
		THREEWORDINLINE(0x7010, 0x3F00, 0xA9E9);

/*
**	Prototypes for functions here
*/

Boolean  HasExtendedDIFunctions(void);
OSErr	FormatAsDOS(short driveNumber, ConstStr255Param volName);


/******************************************************************************/

/*
**	See if new extended Disk Init package is available
*/
Boolean  HasExtendedDIFunctions(void)
{
	long response;
	
	if ( Gestalt(gestaltFSAttr, &response) == noErr )
		return ( (response & (1L << gestaltHasExtendedDiskInit)) != 0 );
	else
		return ( false );
}

/******************************************************************************/

/*
**	Format the unmounted floppy disk specified by driveNum as an MS-DOS disk.
*/
OSErr	FormatAsDOS(short driveNumber, ConstStr255Param volName)
{
	enum
	{
		kMacPCExchangeFSID = 0x4953	/* file system ID of Macintosh PC Exchange's
										MS-DOS file system (see "Guide-File System Mgr" 
										on MacOS SDK in File System Manager SDK).*/
	};
	OSErr			result;
	unsigned long	actSize;
	
	/*
	**	Format the disk. Passing false for fmtFlag and 1440 for fmtArg tells
	**	the Disk Init package to format the disk with 1440 blocks (720K MFM) or
	**	if 1440 blocks isn't available (because the disk is a high density disk),
	**	to format the disk with the smallest size that's greater than 1440 blocks
	**	(which will be 2880 blocks (1440K MFM)).
	*/
	result = DIXFormat(driveNumber, false, 1440, &actSize);
	if ( result == noErr )
	{
		/* Verify the disk */
		result = DIVerify(driveNumber);
		
		/*
		**	The result of DIVerify is passed to DIXZero in the mediaStatus parameter.
		**	If mediaStatus is noErr, then the disk is simply initialized.  If
		**	mediaStatus is not noErr, then DIXZero attempts to spare any bad blocks
		**	if the file system supports that. MS-DOS disks can be bad block spared.
		*/
		result = DIXZero(driveNumber, volName, kMacPCExchangeFSID, result,
						 0, actSize, NULL);
	}
	
	return ( result );
}

/******************************************************************************/

/* Test code */
void	main(void)
{
	short			driveNumber = 1;	/* hard coded to use the 1st floppy drive */
	OSErr			result;
	Str255			volName = "\pMS-DOS Disk";
	
	if ( HasExtendedDIFunctions() )
	{
		result = UnmountVol(NULL, driveNumber);	/* unmount disk in the drive (if it was mounted) */
		result = FormatAsDOS(driveNumber, volName);
	}
}
#endif